/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 01.26.2010		greed	Initial Version
 * 05.04.2010		greed	Made close button visibility = false; They are setting it in the html.
 * 
 */
package
{
	import com.beamland.interfaces.IDisposable;
	import com.beamland.utils.MemoryCleaner;
	
	import flash.display.CapsStyle;
	import flash.display.DisplayObject;
	import flash.display.Graphics;
	import flash.display.JointStyle;
	import flash.display.LineScaleMode;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.DropShadowFilter;
	import flash.utils.getDefinitionByName;
	
	import ui.buttons.CloseButton;

	



	/**
	 * A description of VMUWebZine
	 *
	 * @author Graeme Leffler
	 * @langversion 3.0
	 * @playerversion Flash 10.0.0
	 */
	public class Calculator extends MovieClip implements IDisposable
	{
		
		private var _bg								:Sprite;
		private var _application					:Object = null;
		private var _closeButton					:CloseButton;
		////////////////////////////////////////////////////////////
		//
		// Constructor
		//
		////////////////////////////////////////////////////////////
		/**
		 * Create a new instance of VMUWebZine
		 *
		 */
		public function Calculator()
		{
			super(); 
			super.stop();
			//stage align properties
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
        	__init();
		}

		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////

		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			try
			{
				MemoryCleaner.dispose(this);
			}
			catch($err:Error)
			{
				//do nothing
				////trace(this,'[failed dispose] -', $err);
			}
		}
		
		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////


		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////
		/**
		 * Check to see if all frames have been loaded
		 *  
		 * @param $e
		 * 
		 */		
		private function __onEnterFrame($e:Event):void 
		{
			
			if(super.framesLoaded == super.totalFrames) 
			{
				removeEventListener(Event.ENTER_FRAME, __onEnterFrame);
				
				super.gotoAndStop(2);
				__loadApp();
			}
		}
		
		////////////////////////////////////////////////////////////
		//
		// Protected Methods
		//
		////////////////////////////////////////////////////////////


		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////

		/**
		 * Initialize app, with loader
		 *
		 */
		private function __init():void
		{
			_bg = new Sprite();
			var g:Graphics = _bg.graphics;
			//_bg.filters = [new DropShadowFilter(1,120,0x0000,.5,3,3,1,3)];
			g.lineStyle(1,0xe5e5e5,1,true,LineScaleMode.NORMAL,CapsStyle.ROUND,JointStyle.ROUND)
			g.beginFill(0xffffff);
			g.drawRoundRect(0,0,780, 931,10,10);
			//g.drawRect(0,0,721, 931);
			_bg.x = 0;
			_bg.y = (930 - _bg.height ) >> 1;
			addChild(_bg);
			
			_closeButton = new CloseButton();
			_closeButton.visible = true
			_closeButton.x = _bg.width - _closeButton.width;
			_bg.addChild(_closeButton);
			
			//wait for all frames to load
            addEventListener(Event.ENTER_FRAME,__onEnterFrame,false,0,true);
		}
		
				
		/**
		 * Load the main application 
		 * 
		 */		
		private function __loadApp():void
		{			
		    var CalculatorApplication:Class = Class(getDefinitionByName("CalculatorApp"));
			if(CalculatorApplication)
			{	
				_application = new CalculatorApplication();
				addChild(_application as Sprite);
				_application.start(_bg, _closeButton);
				_application.y = 1;
				_bg = null;
				_closeButton = null;
			} 
		}
		////////////////////////////////////////////////////////////
		//
		// DEBUG METHODS
		//
		////////////////////////////////////////////////////////////
		/**
		 * This is solely for READ ONLY use.
		 * ////traces out mouse path
		 */
		private function __checkMouseEventTrail( $e:MouseEvent ):void
		{
			var p:* = $e.target;
			while(p)
			{
				if(p is DisplayObject)
				{
					////trace (">>", p.name,": ",p, (DisplayObject(p)).x, (DisplayObject(p)).y);
				}
				else
				{
					////trace(">>", p.name,": ",p);
				}
				p = p.parent;
			}
		};
	}
}