/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 01.26.2010		greed	Initial Version
 * 05.04.2010		greed	Made close button visibility = false; They are setting it in the html.
 * 
 */
package
{
	import com.beamland.interfaces.IDisposable;
	import com.beamland.utils.MemoryCleaner;
	import com.greensock.plugins.AutoAlphaPlugin;
	import com.greensock.plugins.BlurFilterPlugin;
	import com.greensock.plugins.MotionBlurPlugin;
	import com.greensock.plugins.TintPlugin;
	import com.greensock.plugins.TransformAroundCenterPlugin;
	import com.greensock.plugins.TransformAroundPointPlugin;
	import com.greensock.plugins.TweenPlugin;
	
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	
	import management.DataManager;
	import management.DisplayManager;
	import management.MetaManager;
	
	import ui.Preloader;
	import ui.buttons.CloseButton;
	



	/**
	 * A description of Calculator App.
	 *
	 * @author Graeme Reed
	 * @langversion 3.0
	 * @playerversion Flash 10.0.0
	 */
	public class CalculatorApp extends Sprite implements IDisposable
	{
		
		private var _meta 							:MetaManager;
		private var _dataManager					:DataManager;
		private var _preloader 						:Preloader;
		private var _displayManager					:DisplayManager;
		private var _bg								:Sprite;
		private var _closeButton					:CloseButton;
		////////////////////////////////////////////////////////////
		//
		// Constructor
		//
		////////////////////////////////////////////////////////////
		/**
		 * Create a new instance of VMUWebZine
		 *
		 */
		public function CalculatorApp()
		{
			super();
		}

		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////

		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			try
			{
				MemoryCleaner.dispose(this);
			}
			catch($err:Error)
			{
				//do nothing
				////trace(this,'[failed dispose] -', $err);
			}
		}
		
		public function start($background:Sprite, $closeButton:CloseButton):void
		{
			_bg = $background;
			addChild(_bg);
			var scaleRect:Rectangle = new Rectangle(20,20,_bg.width - 40, _bg.height - 40);
			_bg.scale9Grid = scaleRect;
			
			_closeButton = $closeButton;
			addChild(_closeButton);
			_closeButton.x = _bg.width - _closeButton.width-1;
			_closeButton.visible = true;
			__init();
		}
		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////


		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////

 		private function __handleDataManagerCompleteSignal():void
		{
			
			////trace('DATA HAS LOADED');
		/* 	_mapView = new Map();
			addChild(_mapView); */
		} 
		
		private function __handleProgressSignal($percent:Number):void
		{
			_preloader.updatePercent($percent);
		}
		
		private function __handlePreloaderSignal($status:String):void
		{
			switch($status)
			{
				case 'animateInComplete': 
					__loadData();
				break;
				
				case 'animateOutComplete':
					__addDisplayManager();
				break;
			}
		}
		
		private function __handleResizeSignal():void
		{
			_bg.height = _displayManager.visibleHeight + 34;
		}

		////////////////////////////////////////////////////////////
		//
		// Protected Methods
		//
		////////////////////////////////////////////////////////////


		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////

		/**
		 * Initialize app, with loader
		 *
		 */
		private function __init():void
		{
			
			TweenPlugin.activate([TintPlugin, TransformAroundCenterPlugin, TransformAroundPointPlugin, MotionBlurPlugin, AutoAlphaPlugin, BlurFilterPlugin]);			
					
			_preloader = new Preloader();
			_preloader.preloaderAnimationSignal.add(__handlePreloaderSignal);
			_preloader.x = ((780 - _preloader.width) >> 1) -21;
			_preloader.y = ((931 - _preloader.height) >> 1)-20;
			addChild(_preloader);
			// debug
			///stage.addEventListener(MouseEvent.CLICK,__checkMouseEventTrail,false,0,true);
		}
		
		private function __loadData():void
		{
			try
			{
			 	var shellXML:String = this.loaderInfo.parameters['xmlPath'];
				_dataManager = DataManager.getInstance();
				_dataManager.shellPath = shellXML;
				_dataManager.progresSignal.add(__handleProgressSignal);
				_dataManager.load(); 
			}
			catch($e:Error)
			{
				////trace($e);
			}
		}
		
		private function __addDisplayManager():void
		{
			_displayManager = new DisplayManager();
			_displayManager.x = 30;
			_displayManager.y = 0;
			_displayManager.resizeSignal.add(__handleResizeSignal);
			addChild(_displayManager);
		}
		////////////////////////////////////////////////////////////
		//
		// DEBUG METHODS
		//
		////////////////////////////////////////////////////////////
		/**
		 * This is solely for READ ONLY use.
		 * ////traces out mouse path
		 */
		private function __checkMouseEventTrail( $e:MouseEvent ):void
		{
			var p:* = $e.target;
			while(p)
			{
				if(p is DisplayObject)
				{
					////trace (">>", p.name,": ",p, (DisplayObject(p)).x, (DisplayObject(p)).y);
				}
				else
				{
					////trace(">>", p.name,": ",p);
				}
				p = p.parent;
			}
		};
	}
}