/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 01.26.2010		greed	Initial Version
 */
 
 

 package data
 {
 	import com.beamland.utils.BooleanUtils;
 	

	/**
	 * A description of ButtonData
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.128.0
	 */
	public class ProviderData
	{
		public static const ROUND_UP			:String = 'round_up';
		public static const ROUND_DOWN			:String = 'round_down';
		public static const ROUND_NONE			:String = 'round_none'
		
		private var _rate						:Number;
		private var _title						:String;
		private var _description				:String;
		private var _id							:String;
		private var _roundType					:String;
		private var _details					:TitleDescriptionData;
		////////////////////////////////////////////////////////////
		//
		// Constructor
		//
		////////////////////////////////////////////////////////////

		/**
		 * Create a new instance of ButtonData
		 *
		 */
		public function ProviderData($xml:XML)
		{
			_id = $xml.attribute('id'); 
			_title = $xml.title[0];
			_description = $xml.description[0];
			_roundType = $xml.attribute('roundType');
			_rate = Number($xml.rate[0]);
			if($xml.details[0]) _details = new TitleDescriptionData($xml.details[0]);
		}

		////////////////////////////////////////////////////////////
		//
		// Getters / Setters
		//
		////////////////////////////////////////////////////////////
		public function get rate():Number
		{
			return _rate;
		}
		
			/**
		 *
		 * @return
		 *
		 */
		public function get title():String
		{
			return _title;
		}

		/**
		 *
		 * @return
		 *
		 */
		public function get id():String
		{
			return _id;
		}
		
		/**
		 *
		 * @return
		 *
		 */
		public function get description():String
		{
			return _description;
		}
		
		/**
		 *
		 * @return
		 *
		 */
		public function get roundType():String
		{
			return _roundType;
		}
		
		/**
		 *
		 * @return
		 *
		 */
		public function get details():TitleDescriptionData
		{
			return _details;
		}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		
		////////////////////////////////////////////////////////////
		//
		// Event Handlers
		//
		////////////////////////////////////////////////////////////


		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
	}
}