/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 03.16.2010		greed	Initial Version
 */
 
 

 package data
 {
	/**
	 * A description of SliderData
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.128.0
	 */
	public class SliderData
	{
		public static const TIME				:String = 'time';
		public static const NUMERICAL			:String = 'numerical';
		
		
		private var _min						:Number;
		private var _max						:Number;
		private var _id							:String;
		private var _title						:String;
		private var _type						:String;
		private var _value						:Number;
		private var _unit						:String;
		////////////////////////////////////////////////////////////
		//
		// Constructor
		//
		////////////////////////////////////////////////////////////

		/**
		 * Create a new instance of ButtonData
		 *
		 */
		public function SliderData($xml:XML)
		{
			_id = $xml.attribute('id'); 
			_min = $xml.min[0];
			_max = $xml.max[0];
			_title = $xml.title[0];
			_type = $xml.attribute('type');
			_value = $xml.defaultValue[0];
			_unit = $xml.unit[0];
		}

		////////////////////////////////////////////////////////////
		//
		// Getters / Setters
		//
		////////////////////////////////////////////////////////////
		
		/**
		 *
		 * @return
		 *
		 */
		public function get title():String
		{
			return _title;
		}

		/**
		 *
		 * @return
		 *
		 */
		public function get id():String
		{
			return _id;
		}
		
		/**
		 *
		 * @return
		 *
		 */
		public function get type():String
		{
			return _type;
		}
		
		/**
		 *
		 * @return
		 *
		 */
		public function get unit():String
		{
			return _unit;
		} 
		
		/**
		 *
		 * @return
		 *
		 */
		public function get max():Number
		{
			return _max;
		}
		
		/**
		 *
		 * @return
		 *
		 */
		public function get min():Number
		{
			return _min;
		}
		
		/**
		 *
		 * @return
		 *
		 */
		public function get value():Number
		{
			return _value;
		}
		/**
		 *
		 * @return
		 *
		 */
		public function set value($value:Number):void
		{
			_value = $value;
		}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		
		////////////////////////////////////////////////////////////
		//
		// Event Handlers
		//
		////////////////////////////////////////////////////////////


		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
	}
}