/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 01.26.2009		greed	Initial Version
 */
 
 
package management
{

	import com.beamland.utils.ColorUtils;
	import com.beamland.utils.TextFieldUtils;
	import com.beamland.utils.XMLUtils;
	
	import data.ProviderData;
	
	import flash.display.Loader;
	import flash.events.ErrorEvent;
	import flash.events.Event;
	import flash.events.IEventDispatcher;
	import flash.events.IOErrorEvent;
	import flash.events.ProgressEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.text.StyleSheet;
	import flash.utils.getTimer;
	
	import org.osflash.signals.Signal;

	/**
	 * 	DataManager loads data from a URLRequest
	 * 	If the data is xml it will attempt to load an associated css file.
	 * 	This class uses a URLLoader object and should be used for text and binary data
	 * 	Recommend using Loader object for swf and image files
	 */
	public class DataManager
	{
		private static var __INSTANCE			:DataManager;		
		//SIGNALS
		public var completeSignal				:Signal;
		public var progresSignal				:Signal = new Signal(Number);
		

		private var _urlLoader					:URLLoader;
		private var _fontLoader					:Loader;
		private var _cssLoader					:URLLoader;
		private var _xmlLoader					:URLLoader;

		private var _shellPath					:String = '';
		private var _shellXML					:XML;
		private var _meta						:MetaManager;

		////////////////////////////////////////////////////////////
		//
		// Constructor
		//
		////////////////////////////////////////////////////////////


		/**
		 *
		 * @param $enforcer
		 * @param $config
		 * @param $target
		 *
		 */
		public function DataManager($enforcer:SingletonEnforcer, $target:IEventDispatcher = null)
		{
			completeSignal = new Signal();
		}

		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////

		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			try
			{
				DataManager.__INSTANCE = null;
			}
			catch($e:Error)
			{
				//do nothing
				////trace(this,'[failed dispose] -',$e);
			}
		}


    	/**
    	 *
    	 * @return
    	 *
    	 */
    	public static function getInstance():DataManager
    	{
    		if (DataManager.__INSTANCE == null)
    		{
    			DataManager.__INSTANCE = new DataManager(new SingletonEnforcer());
    		}
    		return DataManager.__INSTANCE;
    	}


		/**
		 *
		 *
		 */
		public function load():void
		{
			if (!_shellPath)
			{
				throw new Error('DataManager load(), needs a shell xml file');
			}

			//set up managers
			_meta = MetaManager.getInstance();
			
			// setup bulk XML loading listeners
			var xmlRequest:URLRequest = new URLRequest(_shellPath);
			_xmlLoader = new URLLoader();
			_xmlLoader.addEventListener(Event.COMPLETE, __handleShellLoadComplete, false, 0, true);
			_xmlLoader.addEventListener(ErrorEvent.ERROR, __handleLoadXMLError, false, 0, true);
			_xmlLoader.load(xmlRequest);
			
			
		}



		////////////////////////////////////////////////////////////
		//
		// Getters / Setters
		//
		////////////////////////////////////////////////////////////

    	/**
    	 *
    	 * @param $config
    	 *
    	 */
    	public function set shellPath($shellPath:String):void
    	{
			_shellPath = $shellPath;
    	}

		////////////////////////////////////////////////////////////
		//
		// Protected Methods
		//
		////////////////////////////////////////////////////////////


		////////////////////////////////////////////////////////////
		//
		// Event Handlers
		//
		////////////////////////////////////////////////////////////		
		/**
		 * Handles the load of the shell xml. 
		 * @param $e
		 * 
		 */		
		private function __handleShellLoadComplete($e:Event):void
		{
			_xmlLoader.removeEventListener(Event.COMPLETE, __handleShellLoadComplete);
			_xmlLoader.removeEventListener(ErrorEvent.ERROR, __handleLoadXMLError);
       		_shellXML = XMLUtils.removeHTMLEntities(new XML($e.target.data));
       		_xmlLoader = null;
       		__parseShellXML();
       		var cssRequest:URLRequest = new URLRequest(_shellXML.attribute('stylesheet'));
       		_cssLoader = new URLLoader();
       		_cssLoader.addEventListener(Event.COMPLETE, __handleCSSLoadComplete, false, 0, true);
       		_cssLoader.addEventListener(IOErrorEvent.IO_ERROR, __handleLoadCSSError, false, 0, true);
       		_cssLoader.load(cssRequest);       		
		}
			
		/**
		 * Handles the load of the css. 
		 * @param $e
		 * 
		 */		
		private function __handleCSSLoadComplete($e:Event):void
		{
			_cssLoader.removeEventListener(Event.COMPLETE, __handleCSSLoadComplete);
			_cssLoader.removeEventListener(IOErrorEvent.IO_ERROR, __handleLoadCSSError);
       		var style:StyleSheet = new StyleSheet();
			// parse and dispatch
			style.parseCSS($e.target.data);
	        _meta.styleSheet = style;
	        TextFieldUtils.stylesheet = style;
            _cssLoader = null;
	        //Load Fonts
       		var fontRequest:URLRequest = new URLRequest(_shellXML.attribute('fonts'));
       		_fontLoader = new Loader();
       		_fontLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, __handleFontLoadComplete, false, 0, true);
       		_fontLoader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, __handleFontLoadError, false, 0, true);
       		_fontLoader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, __handleProgressEvent, false, 0, true);
       		_fontLoader.load(fontRequest);
	        
		}
		
		private function __handleFontLoadComplete($e:Event):void
		{
			_fontLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, __handleShellLoadComplete);
			_fontLoader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, __handleLoadCSSError);
			_fontLoader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS, __handleProgressEvent);
			this.completeSignal.dispatch();
		}
		
		/**
		 *
		 * @param $e
		 *
		 */
		private function __handleProgressEvent($e:ProgressEvent):void
		{
			this.progresSignal.dispatch($e.bytesLoaded/$e.bytesTotal);
		}

		/**
		 *
		 * @param $e
		 *
		 */
		private function __handleLoadCSSError($e:IOErrorEvent):void
		{
			_cssLoader.removeEventListener(Event.COMPLETE, __handleCSSLoadComplete);
			_cssLoader.removeEventListener(IOErrorEvent.IO_ERROR, __handleLoadCSSError);
			throw new Error('DataManager, failed to load CSS.');
		}
		
		/**
		 *
		 * @param $e
		 *
		 */
		private function __handleLoadXMLError($e:ErrorEvent):void
		{
			_xmlLoader.removeEventListener(Event.COMPLETE, __handleShellLoadComplete);
			_xmlLoader.removeEventListener(ErrorEvent.ERROR, __handleLoadXMLError);
			throw new Error('DataManager, failed to load XML.');
		}
		
		/**
		 *
		 * @param $e
		 *
		 */
		private function __handleFontLoadError($e:ErrorEvent):void
		{
			_fontLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, __handleFontLoadError);
			_fontLoader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, __handleFontLoadError);
			throw new Error('DataManager, failed to load Font swf.');
		}

		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////

		/**
		 *
		 *
		 */
		private function __parseShellXML():void
		{
			var start:Number = getTimer();
			var itemXML:XML;

		 	XMLUtils.sortXMLByAttribute(_shellXML.providers[0],'order',Array.NUMERIC)
			
			//Set primary provider id
			_meta.setPrimaryProviderId(_shellXML.providers.attribute('primaryProviderId'));
			
			for each (itemXML in _shellXML.labels.label)
			{
				//////trace('adding label label :: ------>', itemXML);
				_meta.addLabel(itemXML.attribute('id'),itemXML);
			}
			
			XMLUtils.sortXMLByAttribute(_shellXML.sliders[0],'order',Array.NUMERIC)
			for each (itemXML in _shellXML.sliders.slider)
			{
				////trace('adding slider :: ------>', itemXML.@id);
				_meta.addSlider(itemXML);
			}
			
			for each (itemXML in _shellXML.colors.color)
			{
				//////trace('adding color :: ------>', itemXML);
				_meta.addColor(itemXML.@id, ColorUtils.convertFromCSS(String(itemXML.@hex)));
			}
			
			//Add constants.
			for each (itemXML in _shellXML.constants.constant)
			{
				//////trace('adding color :: ------>', itemXML);
				_meta.addConstant(itemXML.@id, Number(itemXML));
			}
			
			//add providers
			for each (itemXML in _shellXML.providers.provider)
			{
				////trace('new provider :: ------>', itemXML.@id);
				_meta.addProvider(new ProviderData(itemXML));
			}
			
			//Everything has loaded dispatch a signal.
       		this.completeSignal.dispatch();
			////trace("parseShell : ", getTimer() - start + "ms");
		}
	}
}


internal class SingletonEnforcer { }