/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 03.17.2010		greed	Initial Version
 * 05.04.2010		greed	Made title visibility = false; close_text visibility set to false. They are setting it in the html.
 */
 
 
 
package management{

	import com.beamland.interfaces.IDisposable;
	import com.beamland.utils.MemoryCleaner;
	import com.beamland.utils.TextFieldUtils;
	import com.greensock.TweenLite;
	
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	import org.osflash.signals.Signal;
	
	import ui.ProviderGroup;
	import ui.SliderPanel;
	
	/**
	 * The ClassName description.
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.28.0
	 */
	public class DisplayManager extends Sprite implements IDisposable   {
		public var resizeSignal					:Signal = new Signal();
		
		private var _renderXPos					:Number = 0;
		private var _title						:TextField;
		private var _closeText					:Sprite;
		private var _description				:TextField;
		private var _disclaimerTitle			:TextField;
		private var _disclaimer					:TextField;
		private var _extraDisclaimer			:TextField;
		private var _providerGroup				:ProviderGroup;
		private var _sliderPanel				:SliderPanel;
		
		////////////////////////////////////////////////////////////
		// Constructor
		//////////////////////////////////////////////////////////// 
		
		/** 
		 * Creates a new ClassName
		 */ 
     	public function DisplayManager() {
        	super(); 
        	__init();
    	}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			//if dispose fails ... let it fail silently
			try 
			{
				MemoryCleaner.dispose(this);
				_providerGroup = null;
			}
			catch($evt:Error){ throw new Error('Error disposing' + this);}
		}
		
		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////
		private function __handleGroupResize():void
		{
			_disclaimerTitle.y = _providerGroup.y + _providerGroup.visiblHeight + 28;
			_disclaimer.y = _disclaimerTitle.y + _disclaimerTitle.textHeight + 5;
			_extraDisclaimer.y = _disclaimer.y + _disclaimer.textHeight + 15;
			
			this.resizeSignal.dispatch();
		}
		
		private function __handleCloseClick($e:MouseEvent):void
		{
			
		}
		
		private function __handleCloseOver($e:MouseEvent):void
		{
			TweenLite.to(_closeText, 0, {tint:MetaManager.getInstance().getColor('close_text_over')});
		}
		
		private function __handleCloseOut($e:MouseEvent):void
		{
			TweenLite.to(_closeText, 0, {removeTint:true});
		}

		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////
		public function get visibleHeight():Number
		{
			return _extraDisclaimer.y + _extraDisclaimer.textHeight;
		}
		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
		private function __init():void
		{
			var meta:MetaManager = MetaManager.getInstance();
			//Add the providerGroup.
		
			//NOT CURRENTLY BEING USED --- THEY WANT TO ADD IN HTML.
			//title
			_title = TextFieldUtils.createTextField(0,0,720,20,TextFieldAutoSize.LEFT, true);
			_title.htmlText = '<span class="mainTitle">'+ meta.getLabel('main_title') + '</span>';
			//_title.x = 28;
			_title.x = _renderXPos;
			_title.y = 40;
			_title.visible = true;
			addChild(_title);
			
			//NOT CURRENTLY BEING USED --- THEY WANT TO ADD IN HTML.
			//description
			_description = TextFieldUtils.createTextField(0,0,720,20,TextFieldAutoSize.LEFT, true);
			_description.visible = true;
			_description.htmlText = '<span class="mainDescription">'+ meta.getLabel('main_description') + '</span>';
			//_description.x = 30;
			_description.y = _title.y + _title.textHeight + 9;
			addChild(_description);
			
			//Slider panel
			_sliderPanel = new SliderPanel();
			//_sliderPanel.x = 32;
			_sliderPanel.x = _renderXPos;
			//UNCOMMENT IF TITLE AND DESCRIPTION ARE TO BE RENDERED IN FLASH AGAIN.
			_sliderPanel.y = _description.y + _description.textHeight + 20;
			//USE FOR HTML RENDERING OF DESCRIPTION AND TITLE.
			//_sliderPanel.y = 0;
			addChild(_sliderPanel);
			
			_providerGroup = new ProviderGroup(MetaManager.getInstance().getAllProviders());
			_providerGroup.resizeSignal.add(__handleGroupResize);
			//_providerGroup.x = 32;
			_providerGroup.x = _renderXPos;
			//_providerGroup.y = 310;
			_providerGroup.y = _sliderPanel.y + _sliderPanel.height+ 20;
			addChild(_providerGroup);
			
			//Disclaimer title which is a different color and won't line up with the ordered list if in the same field.
			_disclaimerTitle = TextFieldUtils.createTextField(0,0,720,20,TextFieldAutoSize.LEFT, true);
			_disclaimerTitle.htmlText = '<span class="disclaimerTitle">'+meta.getLabel('disclaimer_title') +'<span class="red">'+' '+ meta.getLabel('sign_star')+'</span>'+ '</span>';
			addChild(_disclaimerTitle);
			_disclaimerTitle.y = _providerGroup.y + _providerGroup.visiblHeight + 28;
			//_disclaimerTitle.x = 29;
			_disclaimerTitle.x = _renderXPos;
			
			_disclaimer = TextFieldUtils.createTextField(0,0,710,20,TextFieldAutoSize.LEFT, true);
			_disclaimer.htmlText = '<span class="disclaimer">'+meta.getLabel('disclaimer') + '</span>';
			addChild(_disclaimer);
			_disclaimer.y = _disclaimerTitle.y + _disclaimerTitle.textHeight + 5;
			_disclaimer.x = 11;
			
			_extraDisclaimer = TextFieldUtils.createTextField(0,0,720,20,TextFieldAutoSize.LEFT, true);
			_extraDisclaimer.htmlText = '<span class="extraLegalParagraph">'+meta.getLabel('extra_legal_paragraph') + '</span>';
			_extraDisclaimer.y = _disclaimer.y + _disclaimer.textHeight + 15;
			_extraDisclaimer.x = _disclaimerTitle.x;
			addChild(_extraDisclaimer);
			
			_closeText = new Sprite();
			_closeText.visible = false;
			_closeText.buttonMode = true;
			_closeText.addEventListener(MouseEvent.CLICK, __handleCloseClick, false, 0, true);
			_closeText.addEventListener(MouseEvent.ROLL_OVER, __handleCloseOver, false, 0, true);
			_closeText.addEventListener(MouseEvent.ROLL_OUT, __handleCloseOut, false, 0, true);
			
			var closeField:TextField = TextFieldUtils.createTextField(0,0,20,20,TextFieldAutoSize.LEFT, false);
			closeField.mouseEnabled = false;
			closeField.htmlText = '<span class="closeButton">'+ meta.getLabel('close_window')+'</span>';
			_closeText.addChild(closeField);
			
			_closeText.x = 730 - _closeText.width - 10;
			_closeText. y = (50- _closeText.height) >> 1;
			addChild(_closeText);
			
			
			TweenLite.delayedCall(.01, this.resizeSignal.dispatch);
		}
		
    }
}