/**
 *	@author		Graeme Reed
 *  @email		graeme.reed@beamland.com
 * 	@link		http://www.beamland.com
 *  @version	1.0
 *
 *  @history
 *	03.10.2010		greed		+ Initial Version
 */

 package management
 {
 	
 	import data.ProviderData;
 	import data.SliderData;
 	
 	import flash.text.StyleSheet;
 	
 	import org.osflash.signals.Signal;
 	


	/**
	 * A description of Meta
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.128.0
	 */
	public class MetaManager
	{
		public var totalsUpdatedSignal			:Signal = new Signal(Array);
		
		private static var __INSTANCE			:MetaManager;
		private static const __DEBUG			:Boolean = true;
		public var styleSheet					:StyleSheet;
		public var showUsa						:Boolean;
		private var _labels						:Array			= [];
		private var _providersHash				:Array 			= [];
		private var _providersByIndex			:Array 			= [];
		private var _colors						:Array			= [];
		private var _primaryProviderId			:String;
		private var _slidersByIndex				:Array			= [];
		private var _slidersHash				:Array			= [];
		private var _constants					:Array			= [];
		private var _totals						:Array 			= [];
		////////////////////////////////////////////////////////////
		//
		// Constructor
		//
		////////////////////////////////////////////////////////////

		public function MetaManager($enforcer:SingletonEnforcer)
		{
			if (!$enforcer) throw new Error('Need to pass "Singleton Enforcer" as parameter.');
		}

		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
    	/**
		 * Creates a Meta instance if there isn't one already
		 *
		 * return	Meta instance
		 */
    	public static function getInstance():MetaManager
    	{
    		if (MetaManager.__INSTANCE == null)
    		{
    			MetaManager.__INSTANCE = new MetaManager(new SingletonEnforcer());
    		}
    		return MetaManager.__INSTANCE;
    	}


		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			try
			{
			}
			catch($e:Error)
			{
				//do nothing
				////trace(this,'[failed dispose] -',$e);
			}
		}

	
		////////////////////////////////////////////////////////////
		//
		// Getters / Setters
		//
		////////////////////////////////////////////////////////////
		/**
		 *
		 * @param $id
		 * @param $value
		 *
		 */
		public function addLabel($id:String, $value:String):void
		{
			_labels[$id] = $value;
		}


		/**
		 *
		 * @param $id
		 * @return
		 *
		 */
		public function getLabel($id:String):String
		{
			if(_labels[$id] == null)
			{
				throw new Error('Meta : [' +$id+ '] is an invalid label.');
			}
			return _labels[ $id];
		}

		/**
		 * Adds a country data object and stores it for later use.
		 * @param $id
		 * @return
		 *
		 */
		public function addProvider($providerData:ProviderData):void
		{
			_providersHash[$providerData.id] = $providerData;
			_providersByIndex.push($providerData);
			
			this.calculateTotalForProvider($providerData.id);
		} 
		
		/**
		 * Get data for a specific country.
		 * @param $id The country id from the shell.xml
		 * @return The data for the coutnry that was passed in.
		 * 
		 */		
		public function getProviderById($id:String):ProviderData
		{
			if(_providersHash[$id] == null)
			{
				throw new Error('Meta : [' +$id+ '] is an invalid label.');
			}
			return _providersHash[ $id];
		} 
		
		
		/**
		 * Returns an array of all the country data objects 
		 * @return 
		 * 
		 */		
		public function getAllProviders():Array
		{
			return _providersByIndex;
		}
		
		/**
		 * 
		 * @param $id
		 * @param $color
		 * 
		 */		
		public function addColor($id:String, $color:uint):void
		{
			_colors[$id] = $color;
		}
		
		/**
		 * 
		 * @param $id
		 * @return 
		 * 
		 */		
		public function getColor($id:String):uint
		{
			return _colors[$id] as uint;
		}
		
		/**
		 * 
		 * @param $id
		 * @param $value
		 * 
		 */		
		public function addConstant($id:String, $value:Number):void
		{
			_constants[$id] = $value;
		}
		
		/**
		 * 
		 * @param $id
		 * @return 
		 * 
		 */		
		public function getConstant($id:String):Number
		{
			return _constants[$id] as Number;
		}
		
		/**
		 * 
		 * @param $id
		 * 
		 */		
		public function setPrimaryProviderId($id:String):void
		{
			_primaryProviderId = $id;
		}
		
		/**
		 * 
		 * @return 
		 * 
		 */		
		public function getPrimaryProviderId():String
		{
			return _primaryProviderId;
		}
		
		/**
		 * 
		 * @param $xml
		 * 
		 */		
		public function addSlider($xml:XML):void
		{
			var sd:SliderData = new SliderData($xml);
			_slidersByIndex.push(sd);
			_slidersHash[sd.id] = sd;
		}
		
		/**
		 * 
		 * @param $id
		 * @return 
		 * 
		 */		
		public function getSliderById($id:String):SliderData
		{
			return _slidersHash[$id];
		}
		
		/**
		 * 
		 * @return 
		 * 
		 */		
		public function getAllSliders():Array
		{
			return _slidersByIndex;
		}
		
		/**
		 * 
		 * 
		 */		
		public function calculateTotalForAllProviders():void
		{
			var pd:ProviderData;
			for each(pd in _providersHash)
			{
					
				var totalSeconds:Number =  this.getSliderById('minutes_per_call').value;
				var totalMinutes:Number = totalSeconds/60;
				switch(pd.roundType)
				{
					case ProviderData.ROUND_UP:
						totalMinutes = Math.ceil(totalMinutes);
					break;
					
					case ProviderData.ROUND_DOWN:
						totalMinutes = Math.floor(totalMinutes);
					break;
					
					case ProviderData.ROUND_NONE:
						totalMinutes = totalMinutes;
					break;	
				}
				//trace("----------------------------------------------");
			
				var total:Number = this.getSliderById('calls_per_day').value * this.getConstant('number_of_days')*totalMinutes*pd.rate;
				
				//Round to the hundreths.
				total *= 100;
				total = Math.round(total);
				//total /= 100;
				
				//trace('total', total, 'floor total', Math.floor(total), total - Math.floor(total));
				//trace('x 100 :: ---->', total*100);
				var totalString100:String  = String(int(total));
				//if(totalCents.length == 1) totalCents += '0';
				
				//Convert total to a string.
				////trace('c',int(total), totalCents, total);
				var intTotal:int = Math.floor(total);
				//trace(intTotal);
				var totalString:String;
				if(totalString100.length <= 1)
				{
					totalString  = totalString100.substr(totalString100.length-1) + this.getLabel('sign_cents');
				}
				else if(totalString100.length <= 2)
				{
					totalString  = totalString100.substr(totalString100.length-2) + this.getLabel('sign_cents');
				}
				else
				{
					totalString  = '$'+totalString100.substr(0,totalString100.length-2) + '.' +totalString100.substr(totalString100.length-2);	
				}
				
				if(__DEBUG)
				{
					//trace(pd.id, 'Calculation :: ------->','calls ::',this.getSliderById('calls_per_day').value, 'days ::', this.getConstant('number_of_days'), 'total minutes :: ', totalMinutes, 'rate ::', pd.rate);
					//trace('total for ', pd.id, '::------->', total, totalString);
				}
				_totals[pd.id] = totalString;
			}
			
			//Dispatch an update event with all of the totals.
			this.totalsUpdatedSignal.dispatch(_totals);
		}
		
		/**
		 * Calculate the total for a specific provider. 
		 * @param $id
		 * @return 
		 * 
		 */		
		public function calculateTotalForProvider($id:String):String
		{
			var pd:ProviderData = _providersHash[$id];

			var totalSeconds:Number =  this.getSliderById('minutes_per_call').value;
			var totalMinutes:Number = totalSeconds/60;
			//////trace('total minutes for ', pd.id
			
			switch(pd.roundType)
			{
				case ProviderData.ROUND_UP:
					totalMinutes = Math.ceil(totalMinutes);
				break;
				
				case ProviderData.ROUND_DOWN:
					totalMinutes = Math.floor(totalMinutes);
				break;
				
				case ProviderData.ROUND_NONE:
					totalMinutes = totalMinutes;
				break;	
			}
			
			var total:Number = this.getSliderById('calls_per_day').value * this.getConstant('number_of_days')*totalMinutes*pd.rate;
			
			//Round to the hundreths
			total *= 100;
			total = Math.round(total);
			total /= 100;
			
			//Convert total to a string.			
			var totalCents:String  = String(Math.floor((total -Math.floor(total)) * 100));
				if(totalCents.length == 1) totalCents+= '0';
				
			//Convert total to a string.
			////trace('c',int(total), totalCents, total);
			var intTotal:int = Math.floor(total);
			var totalString:String = (total < 1) ? ((intTotal * 100) + this.getLabel('sign_cents')) : (this.getLabel('sign_dollar') +intTotal + '.' + totalCents);
			if(__DEBUG)
			{
				////trace(pd.id, 'Calculation :: ------->','calls ::',this.getSliderById('calls_per_day').value, 'days ::', this.getConstant('number_of_days'), 'total minutes :: ', totalMinutes, 'rate ::', pd.rate);
				////trace('total for ', pd.id, '::------->', total, totalString);
			}
			
			//Update the totals array
			_totals[pd.id] = totalString;
			
			return totalString;
		}
		
		public function getTotalById($id:String):String
		{
			return _totals[$id];
		}

		
		////////////////////////////////////////////////////////////
		//
		// Event Handlers
		//
		////////////////////////////////////////////////////////////


		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
	}
}

internal class SingletonEnforcer { }