/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 03.30.2010	greed	Initial Version
 */
 
 
 
package ui{

	import com.beamland.interfaces.IDisposable;
	import com.beamland.utils.TextFieldUtils;
	
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.filters.DropShadowFilter;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	/**
	 *
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.28.0
	 */
	public class DetailsBubble extends Sprite implements IDisposable   {
		private var _title							:TextField;
		private var _description					:TextField;
		private var _bubble							:Sprite;
		private var _arrow							:Sprite;
		////////////////////////////////////////////////////////////
		// Constructor
		//////////////////////////////////////////////////////////// 
		
		/** 
		 * Creates a new DetailsButton
		 */ 
     	public function DetailsBubble($title:String, $description:String) {
        	super(); 
        	__init($title, $description);
    	}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			//if dispose fails ... let it fail silently
			try 
			{
				_title = null;
				_description = null;
			}
			catch($evt:Error){ throw new Error('Error disposing' + this);}
		}
		
		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////
		public function setArrowX($xpos:int):void
		{
			_arrow.x = $xpos;
		}
		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////
		
		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
		private function __init($title:String, $description:String):void
		{
			_bubble = new Sprite();
			var g:Graphics = _bubble.graphics;
			g.beginFill(0xffffff);
			g.drawRoundRect(0,0,444,180,15,15);
			addChild(_bubble);
			 
			_arrow = new Sprite();
			g = _arrow.graphics;
			g.beginFill(0xffffff);
			g.lineTo(9,9);
			g.lineTo(18,0);
			_arrow.x = (_bubble.width - _arrow.width) >> 1;
			_arrow.y =_bubble.height;
			_bubble.addChild(_arrow);
					
			_title = TextFieldUtils.createTextField(0,0,100,20,TextFieldAutoSize.LEFT,false);
			_title.htmlText = '<span class ="detailsTitle">'+$title+'</span>';
			_title.x = 22;
			_title.y = 22;
			_bubble.addChild(_title);
			
			_description = TextFieldUtils.createTextField(0,0,395,20,TextFieldAutoSize.LEFT,true);
			_description.htmlText = '<span class ="detailsDescription">'+$description+'</span>';
			_description.x = _title.x;
			_description.y = _title.y + _title.textHeight + 15;
			_bubble.addChild(_description);
			
			this.filters = [new DropShadowFilter(0,120,0,.3,3,3,1,3)];
			
		}
    }
}