/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 03.19.2010		greed	Initial Version
 */
 
 
 
package ui{

	import com.beamland.interfaces.IDisposable;
	import com.beamland.utils.StringUtils;
	import com.beamland.utils.TextFieldUtils;
	import com.greensock.TweenLite;
	
	import data.ProviderData;
	
	import flash.display.Sprite;
	import flash.text.AntiAliasType;
	import flash.text.GridFitType;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	import management.MetaManager;

	
	/**
	 * The MultiplicationTable description.
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.28.0
	 */
	public class MultiplicationTable extends Sprite implements IDisposable   {
		private var _container			:Sprite;
		private var _providerData		:ProviderData;
		private var _days				:MultiplierBox;
		private var _rate				:MultiplierBox;
		private var _calls				:MultiplierBox;
		private var _length				:MultiplierBox;	
		private var _boxes				:Array = [];
		private var _meta				:MetaManager;
		private var _signs				:Array = [];
		private var _isPrimary			:Boolean = false;
		////////////////////////////////////////////////////////////
		// Constructor
		//////////////////////////////////////////////////////////// 
		
		/** 
		 * Creates a new MultiplicationTable
		 */ 
     	public function MultiplicationTable($providerData:ProviderData) {
        	super(); 
        	_providerData = $providerData;
        	__init();
    	}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			//if dispose fails ... let it fail silently
			try 
			{
				_meta.totalsUpdatedSignal.removeAll();
				
				_days = null;
				_calls = null;
				_rate = null;
				_length = null;
				_signs = null;
				_boxes = null;
				_providerData = null;
				_container = null;
				_meta = null;
			}
			catch($evt:Error){ throw new Error('Error disposing' + this);}
		}
		
		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////
		private function __handleTotalsUpdated($totalsHashArray:Array):void
		{
			_calls.setValue(String(_meta.getSliderById('calls_per_day').value));
			//Round the and add the call.
			var totalSeconds:Number =  _meta.getSliderById('minutes_per_call').value;
			var totalMinutes:Number = totalSeconds/60;
			switch(_providerData.roundType)
			{
				case ProviderData.ROUND_UP:
					totalMinutes = Math.ceil(totalMinutes);
				break;
				
				case ProviderData.ROUND_DOWN:
					totalMinutes = Math.floor(totalMinutes);
				break;
				
				case ProviderData.ROUND_NONE:
					totalMinutes = totalMinutes;
				break;	
			}
			////trace('total minutes', totalMinutes);
			totalSeconds = totalMinutes*60;
			
			_length.setValue(StringUtils.formatTime(totalSeconds));
		}

		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////
		public function setBoxTint($color:uint,$removeTint:Boolean = false):void
		{
			var mb:MultiplierBox
			for each(mb in _boxes)
			{
				mb.setBoxTint($color, $removeTint);
			}
		}
		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
		/**
		 * 
		 * 
		 */		
		private function __init():void
		{
			_meta = MetaManager.getInstance();
			_isPrimary = (_providerData.id == _meta.getPrimaryProviderId()) ? true : false;
			var colorClass:String = (_isPrimary) ? 'primaryProviderColor' : 'providerColor';
			_container = new Sprite();
			addChild(_container);
			
			//Add the days.
			_days = new MultiplierBox(String(_meta.getConstant('number_of_days')),'number_of_days', colorClass);	
			
			//Add the calls.		
			_calls = new MultiplierBox(String(_meta.getSliderById('calls_per_day').value),'number_of_calls',colorClass);	
			
			//Round the and add the call.
			var totalSeconds:Number =  _meta.getSliderById('minutes_per_call').value;
			var totalMinutes:Number = totalSeconds/60;
			switch(_providerData.roundType)
			{
				case ProviderData.ROUND_UP:
					totalMinutes = Math.ceil(totalMinutes);
				break;
				
				case ProviderData.ROUND_DOWN:
					totalMinutes = Math.floor(totalMinutes);
				break;
				
				case ProviderData.ROUND_NONE:
					totalMinutes = totalMinutes;
				break;	
			}
			////trace('total minutes', totalMinutes);
			totalSeconds = totalMinutes*60;
			_length = new MultiplierBox(StringUtils.formatTime(totalSeconds),_providerData.roundType,colorClass);	
			
			// Add the rate. Convert the rate to the proper string depending on dollars or cents.
			var rateString:String = (_providerData.rate < 1) ? (Math.round(_providerData.rate * 100) + _meta.getLabel('sign_cents')) : (_meta.getLabel('sign_dollar') +_providerData.rate);
			_rate = new MultiplierBox(rateString,'rate_per_min',colorClass);
			_boxes = [_calls, _days, _length, _rate];
			var box:MultiplierBox;
			var counter:int = 0;
			for each(box in _boxes)
			{
				_container.addChild(box);
				box.x = counter*133;
				var xTf:TextField = TextFieldUtils.createTextField(0,0,47,40,TextFieldAutoSize.NONE,false);
				
				//Check if the box is the last box, use an = sign instead of a X sign.
				var sign:String = (counter == _boxes.length-1) ? 
				'<span class="equalsSign">'+'<span class ="'+colorClass+'">'+_meta.getLabel('sign_equals')+'</span>'+'</span>' 
				: '<span class="multiplySign">'+'<span class ="'+colorClass+'">'+_meta.getLabel('sign_multiply')+'</span>'+'</span>';
				
				xTf.htmlText = sign;
				xTf.antiAliasType = AntiAliasType.ADVANCED;
				xTf.gridFitType = GridFitType.PIXEL;
				xTf.x = box.x+box.width;
				xTf.y = (box.getBoxHeight() - xTf.textHeight) >>1;
				_container.addChild(xTf);
				_signs.push(xTf);
				counter++;
			}
			_meta.totalsUpdatedSignal.add(__handleTotalsUpdated);
		}
    }
}