/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 03.19.2010		greed	Initial Version
 */
 
 
 
package ui{

	import com.beamland.interfaces.IDisposable;
	import com.beamland.utils.TextFieldUtils;
	import com.greensock.TweenLite;
	
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.text.AntiAliasType;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	import management.MetaManager;

	
	/**
	 * The ClassName description.
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.28.0
	 */
	public class MultiplierBox extends Sprite implements IDisposable   {
		private var _bg							:Sprite;
		private var _valueField					:TextField;
		private var _title						:TextField;
		private var _colorClass					:String;
		private var _container					:Sprite;
		////////////////////////////////////////////////////////////
		// Constructor
		//////////////////////////////////////////////////////////// 
		
		/** 
		 * Creates a new ClassName
		 */ 
     	public function MultiplierBox($defaultValue:String, $titleId:String, $colorClass:String) {
        	super(); 
        	_colorClass = $colorClass;
        	__init($defaultValue, $titleId);
    	}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			//if dispose fails ... let it fail silently
			try 
			{
				_bg = null;
				_valueField = null;
				_title = null;
				_container = null;
			}
			catch($evt:Error){ throw new Error('Error disposing' + this);}
		}
		
		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////
		
		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////
		/**
		 * 
		 * @param $value
		 * 
		 */		
		public function setValue($value:String):void
		{
			_valueField.htmlText = '<span class="multiplierBoxValue">'+'<span class ="'+_colorClass+'">'+$value+'</span>'+'</span>';
			_valueField.y = (_bg.height - _valueField.textHeight ) >> 1;
		}
		
		public function getBoxHeight():Number
		{
			return _bg.height;
		}
		
		public function setBoxTint($color:uint, $removeTint:Boolean = false):void
		{
			if($removeTint)
			{
				TweenLite.to(_bg, .25, {removeTint:true});
			/* 	if(_colorClass == 'providerColor')
				{
					TweenLite.to(_title, .25, {removeTint:true});
					TweenLite.to(_valueField, .25, {removeTint:true});
				}
				else
				{
					TweenLite.to(_bg, .25, {removeTint:true});
				} */
			}
			else
			{
				TweenLite.to(_bg, .25, {tint:$color});
				/* if(_colorClass == 'providerColor')
				{
					TweenLite.to(_title, .25, {tint:$color});
					TweenLite.to(_valueField, .25, {tint:$color});
				}
				else
				{
					TweenLite.to(_bg, .25, {tint:$color});
				} */
			}
		}
		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
		/**
		 * 
		 * 
		 */		
		private function __init($defaultValue:String, $titleId:String):void
		{
			var meta:MetaManager = MetaManager.getInstance();
			_bg = new Sprite();
			_bg.y = 0;
			var g:Graphics = _bg.graphics;
			var metaColorId:String = (_colorClass == 'providerColor') ? 'multiplier_box_provider': 'multiplier_box_primary';
			g.beginFill(meta.getColor(metaColorId));
			g.drawRoundRect(0,0,86, 50,8,8);
			addChild(_bg);

			_title = TextFieldUtils.createTextField(0, 0,_bg.width, 40,TextFieldAutoSize.LEFT, true);
			_title.htmlText = '<span class="multiplierBoxTitle">'+'<span class ="'+_colorClass+'">'+meta.getLabel($titleId)+'</span>'+'</span>';
			_title.mouseEnabled = false;
			_title.antiAliasType = AntiAliasType.ADVANCED;
			_title.x = 0;
			_title.y = -_title.textHeight - 10;
			addChild(_title);
			
			_container = new Sprite();
			addChild(_container);
			_valueField = TextFieldUtils.createTextField(0, 0,_bg.width, 40,TextFieldAutoSize.NONE, false);
			_valueField.mouseEnabled = false;
			_valueField.x = 0;
			_valueField.y = 0;
			_container.addChild(_valueField);
			
			this.setValue($defaultValue);
		}
    }
}