/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 03.10.2010		greed	Initial Version
 */
 
 
 
package ui{

	import com.beamland.interfaces.IDisposable;
	import com.beamland.utils.MemoryCleaner;
	import com.beamland.utils.TextFieldUtils;
	import com.greensock.TimelineLite;
	import com.greensock.TweenLite;
	
	import flash.display.BlendMode;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.text.StyleSheet;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	import org.osflash.signals.Signal;
	
	/**
	 * The PriceCircle description.
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.28.0
	 */
	public class Preloader extends Sprite implements IDisposable   {
		public var preloaderAnimationSignal		:Signal = new Signal(String);
		
		private var _smallCircle				:Sprite;
		private var _mediumCircle				:Sprite;
		private var _largeCircle				:Sprite;
		private var _extraLargeCircle			:Sprite;
		private var _introAnimation				:TimelineLite;
		private var _percent					:TextField;
		private var _isFirstUpdate				:Boolean = true;
		
		//Preloader Font
		[Embed(source="../__assets/Museo700-Regular.otf", fontName='Museo700Preloader', fontWeight="regular",
				mimeType="application/x-font", unicodeRange="U+0030-U+0039")]
				private static var Museo700Preloader:Class;

		
		
		////////////////////////////////////////////////////////////
		// Constructor
		//////////////////////////////////////////////////////////// 
		
		/** 
		 * Creates a new PriceCircle
		 */ 
     	public function Preloader() {
        	super(); 
        	__init();
    	}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			//if dispose fails ... let it fail silently
			try 
			{
				 MemoryCleaner.dispose(this);
				 _smallCircle				= null;
				 _mediumCircle				= null;
				 _largeCircle				= null;
				 _extraLargeCircle			= null;
			}
			catch($evt:Error){ throw new Error('Error disposing' + this);}
		}
		
		public function updatePercent($percent:Number):void
		{		
			$percent = Math.floor($percent*100);
			_percent.htmlText = '<span class="percentClass">'+$percent+'</span>';
			_percent.x =  - ((_percent.textWidth+6)>>1);
			_percent.y = - ((_percent.textHeight+6)>>1);
			
			if($percent >= 100)
			{
				_introAnimation.reverse();
			} 
		}
		
		public function hideLoader():void
		{
			_introAnimation.reverse();
		}
		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////
		private function __handleReverseComplete():void
		{
			//////trace('reverse complete');
			this.preloaderAnimationSignal.dispatch('animateOutComplete');
			
		}
		
		private function __handleAnimateInComplete():void
		{
			//////trace('animate in complete');
			this.preloaderAnimationSignal.dispatch('animateInComplete');
			
		}
		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////
		
		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
		private function __init():void
		{
			var tweenTime:Number = .15;
			var blurValue:Number = 30;
			_introAnimation = new TimelineLite({onReverseComplete:__handleReverseComplete, onComplete:__handleAnimateInComplete});
			_introAnimation.stop();
			var g:Graphics;
			_mediumCircle = new Sprite();
			_mediumCircle.x = 23;
			_mediumCircle.y = 40;
			g = _mediumCircle.graphics;
			g.beginFill(0x269fcc, 1);
			g.drawCircle(0,0,25);
			addChild(_mediumCircle);
			_introAnimation.insert(TweenLite.from(_mediumCircle, tweenTime, {autoAlpha:1, scaleX:0, scaleY:0, blurFilter:{blurX:blurValue, blurY:blurValue}}),.05); 
			
			_smallCircle = new Sprite();
			_smallCircle.blendMode = BlendMode.MULTIPLY;
			_smallCircle.x = 28;
			_smallCircle.y = 16;
			g = _smallCircle.graphics;
			g.beginFill(0xdeedcd, 1);
			g.drawCircle(0,0,15);
			addChild(_smallCircle);
			_introAnimation.insert(TweenLite.from(_smallCircle, tweenTime, {autoAlpha:1, scaleX:0,scaleY:0, blurFilter:{blurX:blurValue, blurY:blurValue}}),0); 
			
			_largeCircle = new Sprite();
			g = _largeCircle.graphics;
			g.beginFill(0x7bc143, 1);
			g.drawCircle(0,0,30);
			_largeCircle.x = 89;
			_largeCircle.y = 85;
			addChild(_largeCircle);
			_introAnimation.insert(TweenLite.from(_largeCircle, tweenTime, {autoAlpha:1, scaleX:0,scaleY:0 , blurFilter:{blurX:blurValue, blurY:blurValue}}),tweenTime);
			
			_extraLargeCircle = new Sprite();
			g = _extraLargeCircle.graphics;
			g.beginFill(0x003463, 1);
			g.drawCircle(0,0,50);
			_extraLargeCircle.x = 55;
			_extraLargeCircle.y = 67;
			addChild(_extraLargeCircle);
			_introAnimation.insert(TweenLite.from(_extraLargeCircle, tweenTime, {autoAlpha:1, scaleX:0,scaleY:0, blurFilter:{blurX:blurValue, blurY:blurValue}}),.10);
			
			_introAnimation.play();
			
			var percentStyleSheet:StyleSheet = new StyleSheet();
			var percentClass:Object = new Object();
			percentClass.color ='#FFFFFF';
			percentClass.fontSize = 33;
			percentClass.fontFamily = "Museo700Preloader";
			percentStyleSheet.setStyle(".percentClass", percentClass);
			
			_percent = TextFieldUtils.createTextField(0,0,100,20,TextFieldAutoSize.LEFT,false,percentStyleSheet);
			_percent.htmlText = '<span class="percentClass">'+'0'+'</span>';
			_percent.x =  - ((_percent.textWidth+6)>>1);
			_percent.y = - ((_percent.textHeight+6)>>1);
			_extraLargeCircle.addChild(_percent);
		}
    }
}