/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 03.16.2010		greed	Initial Version
 * 03.23.2010		greed	RollOver bg changes on all providers.  No text change on rollover.
 */
 
 
 
package ui{

	import com.beamland.interfaces.IDisposable;
	import com.beamland.utils.TextFieldUtils;
	import com.greensock.TimelineLite;
	import com.greensock.TweenLite;
	
	import data.ProviderData;
	
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.text.AntiAliasType;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	import management.MetaManager;
	
	import org.osflash.signals.Signal;
	
	import ui.buttons.DetailsButton;

	
	/**
	 * The ProviderBar description.
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.28.0
	 */
	public class ProviderBar extends Sprite implements IDisposable   {
		public var resizeSignal					:Signal = new Signal();
		
		private var _bg							:Sprite;
		private var _data						:ProviderData
		private var _title						:TextField;
		private var _expandedTitle				:TextField;
		private var _cost						:TextField;
		private var _expandedCost				:TextField;
		private var _expandTimeline				:TimelineLite;
		private var _colorClass					:String;
		private var _detailsButton				:DetailsButton;
		
		private var _multiplicationTable		:MultiplicationTable;
		
		private var _isExpanded					:Boolean;
		private var _meta						:MetaManager;
		
		private var _newTotalString				:String;
		private var _isPrimary					:Boolean;
		////////////////////////////////////////////////////////////
		// Constructor
		//////////////////////////////////////////////////////////// 
		
		/** 
		 * Creates a new ClassName
		 */ 
     	public function ProviderBar($providerData:ProviderData, $tl:Number=0, $tr:Number=0, $bl:Number=0, $br:Number=0) {
        	super(); 
        	_meta = MetaManager.getInstance();
        	_data = $providerData;
        	_isPrimary = (_data.id == _meta.getPrimaryProviderId()) ? true : false;
        	__init($tl, $tr, $bl, $br);
    	}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			//if dispose fails ... let it fail silently
			try 
			{
				_bg = null;
				_data = null;
				_title = null;
				_expandedTitle = null;
				_cost = null;
				_expandTimeline = null;
				_multiplicationTable = null;
				resizeSignal = null;
			}
			catch($evt:Error){ throw new Error('Error disposing' + this);}
		}
		
		/**
		 * 
		 * @param $delay
		 * 
		 */		
		public function show($delay:Number=0):void
		{
			TweenLite.to(this, .65, {autoAlpha:1, delay:$delay});
		}
		
		/**
		 * 
		 * @param $delay
		 * 
		 */		
		public function hide($delay:Number=0):void
		{
			TweenLite.to(this, .35, {autoAlpha:0, delay:$delay});
		}
		
		/**
		 * @param $delay Used to add a delay for sequencing the expands of all bars in a group.
		 * 
		 */		
		public function expand($delay:Number = 0):void
		{
			if(_isExpanded) return;
			////trace(_data.id, 'expanding');
			_isExpanded = true;
			if(!_expandTimeline)
			{
				_expandTimeline = new TimelineLite();
				_expandTimeline.stop();
				_expandTimeline.insert(new TweenLite(_title, .35, {autoAlpha:0}), 0 + $delay);
				if(_detailsButton )_expandTimeline.insert(new TweenLite(_detailsButton, .35, {autoAlpha:0}), 0 + $delay);
				_expandTimeline.insert(new TweenLite(_cost, .35, {autoAlpha:0}), 0 + $delay);
				_expandTimeline.insert(new TweenLite(_bg, .35, {height:160, onUpdate:__announceSizeUpdate}), .45 + $delay);
				_expandTimeline.insert(new TweenLite(_expandedTitle, .35, {autoAlpha:1}), .8 + $delay);
				_expandTimeline.insert(new TweenLite(_expandedCost, .35, {autoAlpha:1}), .8 + $delay);
				_expandTimeline.insert(new TweenLite(_multiplicationTable, .35, {autoAlpha:1}), .8 + $delay);
			}
			
			_expandTimeline.gotoAndPlay(0);
		}
		
		/**
		 * 
		 * 
		 */		
		public function contract():void
		{
			if(!_isExpanded) return;
			_isExpanded = false;
			_expandTimeline.reverse();
		}
		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////
		/**
		 * 
		 * 
		 */		
		private function __announceSizeUpdate():void
		{
			this.resizeSignal.dispatch();
		}
		
		/**
		 * 
		 * @param $e
		 * 
		 */		
		private function __handleRollOver($e:MouseEvent):void
		{
			if(_isPrimary)
			{
				TweenLite.to(_bg, .15, {tint:_meta.getColor('primary_provider_bg_over')});
				_multiplicationTable.setBoxTint(_meta.getColor('multiplier_box_primary_over'));
			}
			else
			{
				TweenLite.to(_bg, .15, {tint:_meta.getColor('provider_bg_over')});
				_multiplicationTable.setBoxTint(_meta.getColor('multiplier_box_provider_over'));
			}
		}
		
		/**
		 * 
		 * @param $e
		 * 
		 */		
		private function __handleRollOut($e:MouseEvent):void
		{
			
			TweenLite.to(_bg, .35, {removeTint:true});
			_multiplicationTable.setBoxTint(undefined,true);
		}
		
		private function __handleClick($e:MouseEvent):void
		{
			if(_isExpanded)
			{
				this.contract();
			}
			else
			{
				this.expand();
			}
		}
		
		private function __handleTotalsUpdated($hasArrayOfTotals:Array):void
		{
			_cost.htmlText = '<span class="providerCostContracted">'+'<span class ="'+_colorClass+'">'+String($hasArrayOfTotals[_data.id])+'</span>'+'</span>';
			_expandedCost.htmlText = '<span class="providerCostExpanded">'+'<span class ="'+_colorClass+'">'+String($hasArrayOfTotals[_data.id])+'</span>'+'</span>';
		}
		
		private function __showNewTotal():void
		{
			_cost.htmlText = _newTotalString;
			TweenLite.to(_cost, .15, { blurFilter:{blurX:0,blurY:0}});
		}
		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////
		/**
		 * 
		 * @return 
		 * 
		 */		
		public function get visibleHeight():Number
		{
			return _bg.height;
		}
		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
		/**
		 * 
		 * @param $tl Rounding for top left corner.
		 * @param $tr Rounding for top right corner.
		 * @param $bl Rounding for bottom left corner.
		 * @param $br Rounding for bottom right corner.
		 * 
		 */		
		private function __init($tl:Number, $tr:Number, $bl:Number, $br:Number):void
		{
			_bg = new Sprite();
			var rounding:Number = ($tl !=0 || $bl !=0) ? (($tl == 0) ? $bl : $tl) : 0;
			var g:Graphics = _bg.graphics;
			var bgColor:uint = (_isPrimary) ? _meta.getColor('primary_provider_bg') : _meta.getColor('provider_bg');
			_colorClass = (_isPrimary) ? 'primaryProviderColor' : 'providerColor';
			g.beginFill(bgColor);
			g.drawRoundRectComplex(0,0,720,80,$tl, $tr, $bl, $br );
			var scaleRect:Rectangle = new Rectangle(rounding,rounding,(_bg.width-(rounding<<1)), (_bg.height-(rounding<<1)));
			addChild(_bg);
			
			_title = TextFieldUtils.createTextField(0,0,100,20,TextFieldAutoSize.LEFT,false);
			_title.htmlText = '<span class="providerTitleContracted">'+'<span class ="'+_colorClass+'">'+_data.title+'</span>'+'</span>';
			_title.x = 20;
			_title.y = (_bg.height - _title.textHeight) >> 1;
			
			_expandedTitle = TextFieldUtils.createTextField(0, 0,_bg.width, 20,TextFieldAutoSize.LEFT, true);
			_expandedTitle.htmlText = '<span class="providerTitleExpanded">'+'<span class ="'+_colorClass+'">'+_data.title+'</span>'+'</span>';
			_expandedTitle.mouseEnabled = false;
			_expandedTitle.mouseEnabled = false;
			_expandedTitle.antiAliasType = AntiAliasType.ADVANCED;
			_expandedTitle.x = 20;
			_expandedTitle.y = 13;
			_expandedTitle.visible = false;
			_expandedTitle.alpha = 0;
			addChild(_expandedTitle);
			
			_cost = TextFieldUtils.createTextField(0,0,171,100,TextFieldAutoSize.NONE,false);
			_cost.htmlText = '<span class="providerCostContracted">'+'<span class ="'+_colorClass+'">'+_meta.getTotalById(_data.id)+'</span>'+'</span>';
			_cost.mouseEnabled = false;
			_cost.x = 529;
			_cost.y = (_bg.height - _cost.textHeight) >> 1;
			addChild(_cost);
			
			_expandedCost = TextFieldUtils.createTextField(0,0,171,100,TextFieldAutoSize.NONE,false);
			_expandedCost.htmlText = '<span class="providerCostExpanded">'+'<span class ="'+_colorClass+'">'+_meta.getTotalById(_data.id)+'</span>'+'</span>';
			_expandedCost.mouseEnabled = false;
			_expandedCost.x = 529;
			_expandedCost.y = 85;
			_expandedCost.visible = false;
			_expandedCost.alpha = 0;
			addChild(_expandedCost);

			var description:String = _data.description;
			var rateString:String = (_data.rate < 1) ? (Math.round(_data.rate * 100) + _meta.getLabel('sign_cents')) : (_meta.getLabel('sign_dollar') +_data.rate);
			description = '<span class="providerDescription">'+'<span class ="'+_colorClass+'">'+ '&nbsp;' + description.replace('{{rate}}', rateString) +'<span>'+'</span>';
			_title.mouseEnabled = false;
			_title.htmlText +=  description; 
		
			addChild(_title);
			
			_multiplicationTable = new MultiplicationTable(_data);
			_multiplicationTable.x = 22;
			_multiplicationTable.y = 80;
			_multiplicationTable.visible = false;
			_multiplicationTable.alpha = 0;
			addChild(_multiplicationTable);
			
			if(_data.details) 
			{
				trace('details button for', _data.id);
				_detailsButton = new DetailsButton(_data.details,_isPrimary);
				_detailsButton.x = _title.x + _title.textWidth + 5;
				_detailsButton.y = int(_title.y + _title.textHeight - _detailsButton.visibleHeight - 5);
				addChild(_detailsButton);
			}
			
			this.visible = false;
			this.alpha = 0;
			
			this.buttonMode = true;
			addEventListener(MouseEvent.ROLL_OVER,__handleRollOver, false, 0, true);
			addEventListener(MouseEvent.ROLL_OUT,__handleRollOut, false, 0, true);
			_meta.totalsUpdatedSignal.add(__handleTotalsUpdated);
		}
    }
}