/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 03.16.2010		greed	Initial Version
 */
 
 
 
package ui{

	import com.beamland.interfaces.IDisposable;
	import com.beamland.utils.TextFieldUtils;
	import com.greensock.TweenLite;
	
	import data.ProviderData;
	
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	import management.MetaManager;
	
	import org.osflash.signals.Signal;
	
	/**
	 * The ClassName description.
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.28.0
	 */
	public class ProviderGroup extends Sprite implements IDisposable   {
		
		public var resizeSignal						:Signal = new Signal();
		
		private var _title							:TextField;
		private var _hideShowButton					:TextField;
		private var _hideShowContainer				:Sprite;
		private var _providerBars					:Array = [];
		private var _providers						:Array = [];
		private var _isShowingMath					:Boolean = false;
		private var _meta							:MetaManager;
		////////////////////////////////////////////////////////////
		// Constructor
		//////////////////////////////////////////////////////////// 
		/** 
		 * Creates a new ClassName
		 */ 
     	public function ProviderGroup($providers:Array) {
        	super(); 
        	_providers = $providers;
        	__init();
    	}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			//if dispose fails ... let it fail silently
			try 
			{
				_hideShowButton.removeEventListener(MouseEvent.CLICK, __handleHideShowButtonClick); 
				 resizeSignal					= null;
				 _title							= null;
				 _hideShowButton				= null;
				 _providerBars					= null;
				 _providers						= null;
			}
			catch($evt:Error){ throw new Error('Error disposing' + this);}
		}
		
		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////
		/**
		 * 
		 * @param $e
		 * 
		 */		
		private function __handleHideShowButtonClick($e:MouseEvent):void
		{
			_isShowingMath = !_isShowingMath;
			if(_isShowingMath)
			{
				//Update the button text.
				_hideShowButton.htmlText = '<span class="hideShowButton">'+_meta.getLabel('hide_math')+'</span>';
				_hideShowContainer.x = 720 - _hideShowContainer.width;
				_hideShowContainer.y = _title.y + _title.textHeight - _hideShowContainer.height;
				
				//Show math
				__showHideMath(true);
			}
			else
			{
				//Update the button text.
				_hideShowButton.htmlText = '<a href="" class="hideShowButton">'+_meta.getLabel('show_math')+'</a>';
				_hideShowContainer.x = 720 - _hideShowContainer.width;
				_hideShowContainer.y = _title.y + _title.textHeight - _hideShowContainer.height;
				
				//Hide math.
				__showHideMath(false);
			}
		}
	
		/**
		 * 
		 * @param $e
		 * 
		 */		
		private function __handleHideShowButtonOver($e:MouseEvent):void
		{
			TweenLite.to(_hideShowContainer, 0, {tint:_meta.getColor('hide_show_button_over')});
		}
	
		/**
		 * 
		 * @param $e
		 * 
		 */		
		private function __handleHideShowButtonOut($e:MouseEvent):void
		{
			TweenLite.to(_hideShowContainer, 0, {removeTint:true});
		}
		
		/**
		 * 
		 * @param $currentVisibleHeight
		 * Loops through all bars, each bars y position according to the previous bars position and its visible height.
		 * 
		 */		
		private function __handleProviderBarResizeSignal():void
		{
			var pb:ProviderBar;
			var previousPb:ProviderBar;
			////trace('resize signal');
			for each(pb in _providerBars)
			{
				if(previousPb)
				{
					pb.y = previousPb.y + previousPb.visibleHeight + 4;
				}
				previousPb = pb;
			}
			this.resizeSignal.dispatch();
		}
		
		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////
		/**
		 * 
		 * @return 
		 * 
		 */		
		public function get visiblHeight():Number
		{
			var lastPb:ProviderBar = ProviderBar(_providerBars[_providerBars.length-1]);
			////trace(lastPb.visibleHeight, lastPb.y);
			var vw:Number = lastPb.visibleHeight + lastPb.y;
			lastPb = null;
			return vw;
			
		}
		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
		/**
		 * 
		 * 
		 */		
		private function __init():void
		{
			_meta = MetaManager.getInstance()
			_title = TextFieldUtils.createTextField(0,0,100,20,TextFieldAutoSize.LEFT,false);
			_title.x = -3;
			_title.htmlText = '<span class="providerPanelTitle">'+_meta.getLabel('estimated_monthly')+'<span class="red">'+' '+ _meta.getLabel('sign_star')+'</span>'+'</span>';
			addChild(_title);
			
			_hideShowContainer = new Sprite();
			_hideShowContainer.buttonMode = true;
			addChild(_hideShowContainer);
			_hideShowButton = TextFieldUtils.createTextField(0,0,20,20,TextFieldAutoSize.LEFT,false);
			_hideShowButton.htmlText = '<a href="" class="hideShowButton">'+_meta.getLabel('show_math')+'</a>';
			_hideShowButton.mouseEnabled = false;
		 	_hideShowContainer.addEventListener(MouseEvent.CLICK, __handleHideShowButtonClick, false, 0, true); 
		 	_hideShowContainer.addEventListener(MouseEvent.ROLL_OUT, __handleHideShowButtonOut, false, 0, true); 
		 	_hideShowContainer.addEventListener(MouseEvent.ROLL_OVER, __handleHideShowButtonOver, false, 0, true); 
			_hideShowContainer.addChild(_hideShowButton);
			_hideShowContainer.x = 720 - _hideShowContainer.width;
			_hideShowContainer.y = _title.y + _title.textHeight - _hideShowContainer.height;
			
			var pd:ProviderData;
			var counter:int = 0;
			var cornerRadius:int = 3;
			for each(pd in _providers)
			{
				var roundedCornerArray:Array = (counter == 0) ? [cornerRadius,cornerRadius,0,0] :  ((counter == _providers.length -1) ? [0,0,cornerRadius,cornerRadius] : [0,0,0,0]);
				var pb:ProviderBar = new ProviderBar(pd,roundedCornerArray[0],roundedCornerArray[1],roundedCornerArray[2],roundedCornerArray[3]);
				pb.addEventListener(MouseEvent.CLICK, __handleHideShowButtonClick, false, 0, true);
				pb.resizeSignal.add(__handleProviderBarResizeSignal);
				_providerBars.push(pb);
				pb.x = 0;
				//////trace("creating new bar :: ------->", roundedCornerArray );
				//////trace("creating new bar :: visibleHeight :: ------->", pb.visibleHeight );
				pb.y = counter * (pb.visibleHeight + 3) + _title.y + _title.textHeight + 17;
				addChild(pb);
				
				//Transition in.
				pb.show((.35/_providers.length)*counter);
				counter++;
				roundedCornerArray = null;
			}
		}
		
		/**
		 * Calls the expand function on each provider bar in the _providerBars array.
		 * 
		 */		
		private function __showHideMath($showMath:Boolean):void
		{
			var pb:ProviderBar;
			for each(pb in _providerBars)
			{
				if($showMath) pb.expand();
				else pb.contract();
				
			}
		}
    }
}