/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 03.18.2010		greed	Initial Version
 */
 
 
package ui{

	import com.beamland.interfaces.IDisposable;
	import com.beamland.utils.TextFieldUtils;
	import com.greensock.TweenLite;
	
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.EventDispatcher;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.text.AntiAliasType;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	import management.MetaManager;
	
	import org.osflash.signals.natives.NativeSignal;

	
	/**
	 * The ClassName description.
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.28.0
	 */
	public class Scrubber extends Sprite implements IDisposable{
		public var rollOverSignal				:NativeSignal = new NativeSignal(this as EventDispatcher, MouseEvent.ROLL_OVER, MouseEvent);
		public var rollOutSignal				:NativeSignal = new NativeSignal(this as EventDispatcher, MouseEvent.ROLL_OUT, MouseEvent);
		
		private var _container					:Sprite;
		private var _bubble						:Shape;
		private var _pointer					:Shape;
		private var _valueField					:TextField;
		private var _unitsField					:TextField;
		private var _overColor					:uint;
		private var _outColor					:uint;
		private var _ct							:ColorTransform;
		////////////////////////////////////////////////////////////
		// Constructor
		//////////////////////////////////////////////////////////// 
		
		/** 
		 * Creates a new ClassName
		 */ 
     	public function Scrubber($width:Number, $units:String) {
        	super(); 
        	var meta:MetaManager = MetaManager.getInstance();
        	_outColor = meta.getColor('slider_scrubber');
        	_overColor = meta.getColor('slider_scrubber_over');
        	__init($width, $units);
    	}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			//if dispose fails ... let it fail silently
			try 
			{
				_bubble = null;
				_pointer = null;
				_valueField = null;
				_container = null;
				_valueField = null;
				_unitsField = null;
				
			}
			catch($evt:Error){ throw new Error('Error disposing' + this);}
		}
		
		
		
		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////
		private function __handleRollOver($e:MouseEvent):void
		{
		
			TweenLite.to(_bubble, .25, {tint:_overColor});
			TweenLite.to(_pointer, .25, {tint:_overColor});
		}
		
		private function __handleRollOut($e:MouseEvent):void
		{
			TweenLite.to(_bubble, .25, {removeTint:true});
			TweenLite.to(_pointer, .25, {removeTint:true});
		}
		
	
		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////
		public function setValue($value:String):void
		{
			_valueField.htmlText = '<span class="sliderValue">'+$value+'</span>';
		}
		
		public function setTint($remove:Boolean = false):void
		{
			if($remove)
			{
					TweenLite.to(_bubble, .25, {removeTint:true});
					TweenLite.to(_pointer, .25, {removeTint:true});
			}
			else
			{
				TweenLite.to(_bubble, .25, {tint:_overColor});
				TweenLite.to(_pointer, .25, {tint:_overColor});
			}
		}
		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
		private function __init($width:Number, $units:String):void
		{
			this.buttonMode = true;
			_container = new Sprite();
			addChild(_container);
			_bubble = new Shape();
			var g:Graphics = _bubble.graphics;
			g.beginFill(_outColor);
			g.drawRoundRect(0,0,$width, 43,8,8);
			_container.addChild(_bubble);
			_container.x = -(_bubble.width >> 1);
			_container.y = -_container.height;
			
			_valueField = TextFieldUtils.createTextField(0, 0,_bubble.width, 20,TextFieldAutoSize.NONE, false);
			_valueField.mouseEnabled = false;
			_valueField.x = _bubble.x;
			_valueField.y = 0;
			_container.addChild(_valueField);
			
			_unitsField = TextFieldUtils.createTextField(0, 0,_bubble.width, 20,TextFieldAutoSize.NONE, false);
			_unitsField.htmlText = '<span class="sliderUnits">'+$units+'</span>';
			_unitsField.mouseEnabled = false;
			_unitsField.antiAliasType = AntiAliasType.ADVANCED;
			_unitsField.x = _bubble.x;
			_unitsField.y = 22;
			_container.addChild(_unitsField);
			
			_pointer = new Shape();
			g = _pointer.graphics;
			g.beginFill(_outColor);
			g.lineTo(14,0);
			g.lineTo(7,7);
			g.lineTo(0,0);
			_pointer.x = -7;
			_pointer.y = 0;
			addChild(_pointer);
			
			addEventListener(MouseEvent.ROLL_OVER, __handleRollOver, false, 0, true);
			addEventListener(MouseEvent.ROLL_OUT, __handleRollOut, false, 0, true);
		}
    }
}