/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 03.17.2010		greed	Initial Version
 */
 
 
 
package ui{

	import com.beamland.interfaces.IDisposable;
	import com.beamland.utils.MappingUtils;
	import com.beamland.utils.StringUtils;
	import com.beamland.utils.TextFieldUtils;
	import com.greensock.TweenLite;
	import com.greensock.easing.Expo;
	
	import data.SliderData;
	
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.text.AntiAliasType;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	import management.MetaManager;
	
	import org.osflash.signals.Signal;
	
	/**
	 * The ClassName description.
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.28.0
	 */
	public class Slider extends Sprite implements IDisposable   {	
		private const __LARGE_WIDTH			:int = 325;
		private const __LARGE_HEIGHT		:int = 9;
		private const __LARGE_RADIUS		:int = 15;
		
		public var 	sliderUpdateSignal		:Signal  = new Signal()
				
		private var _title					:TextField;
		private var _track					:Shape;
		private var _fill					:Shape;
		private var _barMask				:Shape;
		private var _barContainer			:Sprite;
		private var _sliderContainer		:Sprite;
	
		private var _data					:SliderData;
		private var _dragRect				:Rectangle;
		private var _previousX				:Number;
		
		private var _defaultValue			:Number;
		private var _percent				:Number = 0;
		private var _sliderValue			:Number;
		private var _scrubber				:Scrubber;
	
		////////////////////////////////////////////////////////////
		// Constructor
		//////////////////////////////////////////////////////////// 
		
		/** 
		 * Creates a new Slider
		 */ 
     	public function Slider($sliderData:SliderData) 
     	{
        	super(); 
        	_data = $sliderData;
        	__init();
    	}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			//if dispose fails ... let it fail silently
			try 
			{
				_scrubber.rollOverSignal.removeAll();
				_scrubber.rollOutSignal.removeAll();
				_scrubber.removeEventListener(MouseEvent.MOUSE_DOWN, __handleControlDown);
				
				
				
				sliderUpdateSignal		= null;		
				_title					= null;
				_track					= null;
				_fill					= null;
				_barMask				= null;
				_barContainer			= null;
				_sliderContainer		= null;
				_data					= null;
				_dragRect				= null;
				_scrubber				= null;
			}
			catch($evt:Error){ throw new Error('Error disposing' + this);}
		}
		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////
		/**
		 * 
		 * @param $e
		 * 
		 */		
		private function __handleControlDown($e:MouseEvent):void
		{
			_scrubber.removeEventListener(MouseEvent.MOUSE_DOWN, __handleControlDown);
			_previousX = _scrubber.x;
			_scrubber.startDrag(false, _dragRect);	
			_scrubber.addEventListener(MouseEvent.MOUSE_UP, __handleControlUp, false, 0, true);
			addEventListener(Event.ENTER_FRAME, __updateSlider, false, 0, true);
			stage.addEventListener(MouseEvent.MOUSE_UP, __handleControlUp, false, 0, true);
		}
		
		/**
		 * 
		 * @param $e
		 * 
		 */		
		private function __handleControlUp($e:MouseEvent):void
		{
			removeEventListener(Event.ENTER_FRAME, __updateSlider);
			_scrubber.removeEventListener(MouseEvent.MOUSE_UP, __handleControlUp);
			stage.removeEventListener(MouseEvent.MOUSE_UP, __handleControlUp);
			_scrubber.stopDrag();
			__updateSlider();
			_scrubber.addEventListener(MouseEvent.MOUSE_DOWN, __handleControlDown, false,0, true);
		}
		
		/**
		 * 
		 * @param $e
		 * 
		 */		
		private function __handleBarClick($e:MouseEvent):void
		{
			TweenLite.to(_fill, .75, {width: _barContainer.mouseX, ease:Expo.easeInOut});
			TweenLite.to(_scrubber, .75, {x: _barContainer.mouseX+_barContainer.x, motionBlur:true, ease:Expo.easeInOut, onUpdate:__updateSlider});
		}
		
		/**
		 * 
		 * @param $e
		 * 
		 */		
		private function __handleMinClick($e:MouseEvent):void
		{
			TweenLite.to(_fill, .75, {width:0, ease:Expo.easeInOut});
			TweenLite.to(_scrubber, .75, {x:_barContainer.x,motionBlur:true, ease:Expo.easeInOut, onUpdate:__updateSlider});
		}
		
		/**
		 * 
		 * @param $e
		 * 
		 */		
		private function __handleMaxClick($e:MouseEvent):void
		{
			TweenLite.to(_fill, .75, {width: _barContainer.width, ease:Expo.easeInOut});
			TweenLite.to(_scrubber, .75, {x: _barContainer.width + _barContainer.x, motionBlur:true, ease:Expo.easeInOut, onUpdate:__updateSlider});
		}
		
		/**
		 * 
		 * @param $e
		 * 
		 */		
		private function __updateSlider($e:Event = null):void
		{
			_fill.width = _scrubber.x - _barContainer.x;
			_percent = _fill.width / _track.width;
			_sliderValue = Math.round(MappingUtils.map(_percent,0,1,_data.min,_data.max));
			_scrubber.x = _barContainer.x + _percent*_barContainer.width;
			_fill.width = _percent*_barContainer.width;
			_data.value = _sliderValue;
			var value:String = (_data.type == SliderData.TIME) ? StringUtils.formatTime(_sliderValue) : String(_sliderValue);
			_scrubber.setValue(value);
			
			sliderUpdateSignal.dispatch();
		}
	
		private function __handleScrubberMouseSignal($e:MouseEvent):void
		{
			//trace('scrubber over');
			switch($e.type)
			{
				case MouseEvent.ROLL_OVER:
					TweenLite.to(_track, .25, {tint:0xd3eac1});
					TweenLite.to(_fill, .25, {tint:0xa3d977});
				break;
				
				case MouseEvent.ROLL_OUT:
					TweenLite.to(_fill, .25, {removeTint:true});
					TweenLite.to(_track, .25, {removeTint:true});
				break;
			}
		}
		
		private function __handleBarOver($e:MouseEvent):void
		{
			TweenLite.to(_track, .35, {tint:0xd3eac1});
			TweenLite.to(_fill, .35, {tint:0xa3d977});
			_scrubber.setTint();
		}
		
		private function __handleBarOut($e:MouseEvent):void
		{
			TweenLite.to(_fill, .35, {removeTint:true});
			TweenLite.to(_track, .35, {removeTint:true});
			
			var removeTint:Boolean = true;
			_scrubber.setTint(removeTint);
		}
		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////
		
		/**
		 * Sets the value of the slider and repositions the control and fill accordingly.  A value is passed in,
		 * that value is mapped to a percentage, then the control position is moved to an x coordinate, 
		 * calculated by multiplying the max range it can move by the percentage plus its zero value (the radius of the control); 
		 * 
		 * @param $int
		 * @param $dispatchSignal
		 * 
		 */		
		public function setValue($number:Number,$dispatchSignal:Boolean = true ):void
		{		
			_sliderValue = $number;
			////trace('data', _sliderValue, _data.min, _data.max, 0, 1);
			_percent =  MappingUtils.map(_sliderValue,_data.min,_data.max, 0, 1);
			_scrubber.x = _barContainer.x + _percent*_barContainer.width;
			_fill.width = _percent*_barContainer.width;
			_data.value = _sliderValue;
			
			var value:String = (_data.type == SliderData.TIME) ? StringUtils.formatTime(_sliderValue) : String(_sliderValue);
			_scrubber.setValue(value);
						
			if($dispatchSignal)
			{
				sliderUpdateSignal.dispatch();
			}
			////trace('value is ', _data.value);
		}
		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
		/**
		 * 
		 * 
		 */		
		private function __init():void
		{
			
			_title = TextFieldUtils.createTextField(0,0,20,20,TextFieldAutoSize.LEFT,false);
			_title.htmlText = '<span class="sliderTitle">'+_data.title+'</sppn>';
			_title.antiAliasType = AntiAliasType.ADVANCED;
			_title.x = 0;
			addChild(_title);
			
			_sliderContainer = new Sprite();
			_sliderContainer.y = _title.y + _title.textHeight + 55;
			addChild(_sliderContainer);

			var minTf:TextField = TextFieldUtils.createTextField(0,0,20,20,TextFieldAutoSize.LEFT,false);
			var minValue:Number = (_data.type == SliderData.TIME) ? _data.min/60 : _data.min;
			minTf.htmlText = '<span class="sliderMinMax">'+minValue+'</sppn>';
			minTf.addEventListener(MouseEvent.CLICK, __handleMinClick, false, 0, true);
			minTf.y = _sliderContainer.y;
			minTf.antiAliasType = AntiAliasType.ADVANCED;
			addChild(minTf)
			
			var meta:MetaManager = MetaManager.getInstance();
			var g:Graphics;
			_barContainer = new Sprite();
			_barContainer.buttonMode = true;	
			_barContainer.addEventListener(MouseEvent.CLICK, __handleBarClick, false, 0, true);
			_barContainer.addEventListener(MouseEvent.ROLL_OUT, __handleBarOut, false, 0, true);
			_barContainer.addEventListener(MouseEvent.ROLL_OVER, __handleBarOver, false, 0, true);
			_sliderContainer.addChild(_barContainer);
			_barContainer.x = int(minTf.x + minTf.textWidth + 10);
			
			_track = new Shape();
			g = _track.graphics;
			g.beginFill(meta.getColor('slider_track'));
			g.drawRect(0,0,258, 20);
			g.endFill();
			_barContainer.addChild(_track);
			
			_fill = new Shape();
			g = _fill.graphics;
			g.beginFill(meta.getColor('slider_fill'));
			g.drawRect(0,0,258, 20);
			g.endFill();
			_barContainer.addChild(_fill);
			
			_barMask = new Shape();
			g = _barMask.graphics;
			g.beginFill(0xFF0000);
			g.drawRoundRect(0,0,258, 20,5, 5);
			g.endFill();
			_barMask.x = minTf.x + minTf.textWidth + 10;
			_sliderContainer.addChild(_barMask);
			_barContainer.mask = _barMask;
			
			_dragRect = new Rectangle(_barContainer.x,1, _barContainer.width,0);

			var maxTf:TextField = TextFieldUtils.createTextField(0,0,20,20,TextFieldAutoSize.LEFT,false);
			var maxValue:Number = (_data.type == SliderData.TIME) ? _data.max/60 : _data.max;
			maxTf.addEventListener(MouseEvent.CLICK, __handleMaxClick, false, 0, true);
			maxTf.htmlText = '<span class="sliderMinMax">'+maxValue+'</sppn>';
			maxTf.antiAliasType = AntiAliasType.ADVANCED;
			maxTf.x = _barContainer.width +_barContainer.x+ 5;
			maxTf.y = _sliderContainer.y;
			addChild(maxTf);
			
			var scrubberWidth:Number =  (_data.type == SliderData.TIME) ? 65 : 57;
			_scrubber = new Scrubber(scrubberWidth, _data.unit);
			_sliderContainer.addChild(_scrubber);
			_scrubber.y = 1;
			_scrubber.x = _barContainer.x;
			_scrubber.addEventListener(MouseEvent.MOUSE_DOWN, __handleControlDown, false,0, true);
			_scrubber.rollOverSignal.add(__handleScrubberMouseSignal);
			_scrubber.rollOutSignal.add(__handleScrubberMouseSignal);
			
			this.setValue(_data.value);
		}
		
    }
}