/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 03.17.2010		greed	Initial Version
 */
 
 
package ui{

	import com.beamland.interfaces.IDisposable;
	
	import data.SliderData;
	
	import flash.display.CapsStyle;
	import flash.display.Graphics;
	import flash.display.JointStyle;
	import flash.display.LineScaleMode;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.filters.DropShadowFilter;
	
	import management.MetaManager;

	
	/**
	 * The ClassName description.
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.28.0
	 */
	public class SliderPanel extends Sprite implements IDisposable   {
		private var _bg								:Sprite;
		private var _meta							:MetaManager;
		////////////////////////////////////////////////////////////
		// Constructor
		//////////////////////////////////////////////////////////// 
		
		/** 
		 * Creates a new ClassName
		 */ 
     	public function SliderPanel() {
        	super(); 
        	__init();
    	}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			//if dispose fails ... let it fail silently
			try 
			{
				_bg = null;
			}
			catch($evt:Error){ throw new Error('Error disposing' + this);}
		}
		
		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////
		private function __handleSliderUpdateSignal():void
		{
			_meta.calculateTotalForAllProviders();
		}

		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////

		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
		private function __init():void
		{
			_meta = MetaManager.getInstance();
			_bg = new Sprite();
			_bg.filters = [new DropShadowFilter(0,120,0xf5f5f5,1,30,30,1,3,true)];
			var g:Graphics = _bg.graphics;
			g.lineStyle(1,0xe5e5e5,1,true,LineScaleMode.NONE,CapsStyle.ROUND,JointStyle.ROUND);
			g.beginFill(0xfefefe);
			g.drawRoundRect(0,0,720, 145,8,8);
			addChild(_bg);
			
			var sd:SliderData;
			var previousSlider:Slider;
			var counter:int = 0;
			var sliders:Array = _meta.getAllSliders();
			var sectionWidth:Number = _bg.width/sliders.length;
			for each(sd in sliders)
			{
				var slider:Slider = new Slider(sd);
				slider.sliderUpdateSignal.add(__handleSliderUpdateSignal);
				addChild(slider);
				slider.x = counter*(sectionWidth) + ((sectionWidth - slider.width)>>1);
				slider.y = 19;
				
				//Add vertical dotted line
				if(previousSlider)
				{
					////trace('creating dotted line');
					var dottedCounter:int = 0;
					var newLine:Shape = new Shape();
					newLine.graphics.beginFill(_meta.getColor('dotted_line'));
					newLine.x = int(sectionWidth*counter);
					newLine.y = 0;
					var count:int = Math.round(_bg.height / 3);
					for(dottedCounter = 0; dottedCounter < count; dottedCounter++)
					{
						newLine.graphics.drawRect(0,dottedCounter*3,1,1);
					}
					addChild(newLine);
				}
				
				previousSlider = slider;
				counter++;
			}
		}
    }
}