/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 03.16.2010		greed	Initial Version
 */
 
 
package ui.buttons{

	import com.beamland.interfaces.IDisposable;
	
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;

	
	/**
	 * The ClassName description.
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.28.0
	 */
	public class CloseButton extends Sprite implements IDisposable   {
		private var _bg									:Sprite;
		private var _graphic							:Sprite;
		////////////////////////////////////////////////////////////
		// Constructor
		//////////////////////////////////////////////////////////// 
		
		/** 
		 * Creates a new ClassName
		 */ 
     	public function CloseButton() {
        	super();
        	__init();
    	}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			//if dispose fails ... let it fail silently
			try 
			{
					_bg = null;
					_graphic = null;
					removeEventListener(MouseEvent.ROLL_OVER, __handleRollOver);
					removeEventListener(MouseEvent.ROLL_OUT, __handleRollOut);
			}
			catch($evt:Error){ throw new Error('Error disposing' + this);}
		}
		
		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////
		private function __handleRollOver($e:MouseEvent):void
		{
			var ctX:ColorTransform = new ColorTransform();
			var ctBg:ColorTransform = new ColorTransform();
			ctBg.color = 0x224f78 ;//0x269fcc;
			ctX.color = 0xFFFFFF ;//0x269fcc;
			_graphic.transform.colorTransform = ctX;
			_bg.transform.colorTransform = ctBg;
		}
		
		private function __handleRollOut($e:MouseEvent):void
		{
			var ct:ColorTransform = new ColorTransform();
			_bg.transform.colorTransform = ct;
			_graphic.transform.colorTransform = ct;
		}
		
		private function __handleRollClick($e:MouseEvent):void
		{
		
		}

		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////

		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
		private function __init():void
		{
			_bg = new Sprite();
			var g:Graphics = _bg.graphics;
			g.beginFill(0xFFFFFF);
			g.drawRoundRectComplex(0,0,50, 50,0,2,0,0);
			g.beginFill(0xe5e5e5);
			g.drawRect(0,0,1,50);
			g.drawRect(0,49,50,1);
			addChild(_bg);
			
			_graphic = new Sprite();
			g = _graphic.graphics;
			g.lineStyle(1.5,0x224f78);
			g.beginFill(0);
			g.lineTo(19,19);
			g.moveTo(0,19);
			g.lineTo(19,0);
			_graphic.x = ((_bg.width - _graphic.width) >> 1)+2;
			_graphic.y = (_bg.height - _graphic.height) >> 1;
			addChild(_graphic);
			
			this.buttonMode = true;
			addEventListener(MouseEvent.ROLL_OVER, __handleRollOver, false, 0, true);
			addEventListener(MouseEvent.ROLL_OUT, __handleRollOut, false, 0, true);
		}
    }
}