/**
 * @author		Graeme Reed
 * @email		graeme.reed@beamland.com
 * @link		http://www.beamland.com
 * @version		1.0
 *
 * @history
 * 03.30.2010	greed	Initial Version
 */
 
 
 
package ui.buttons{

	import com.beamland.interfaces.IDisposable;
	import com.beamland.utils.MemoryCleaner;
	import com.beamland.utils.TextFieldUtils;
	import com.greensock.TweenLite;
	
	import data.TitleDescriptionData;
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.AntiAliasType;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	import management.MetaManager;
	
	import ui.DetailsBubble;
	
	/**
	 * Makes a small text link and has a bubble that pops up over it.
	 *
	 * @langversion 3.0
	 * @playerversion Flash 9.0.28.0
	 */
	public class DetailsButton extends Sprite implements IDisposable   {
		private var _linkCopy						:TextField;
		private var _linkCopyContainer				:Sprite;
		private var _isPrimary						:Boolean;
		private var _colorClass						:String;
		private var _bubble							:DetailsBubble;
		private var _data							:TitleDescriptionData;
		
		////////////////////////////////////////////////////////////
		// Constructor
		//////////////////////////////////////////////////////////// 
		
		/** 
		 * Creates a new DetailsButton
		 */ 
     	public function DetailsButton($data:TitleDescriptionData, $isPrimary:Boolean) {
        	super(); 
        	addEventListener(Event.ADDED_TO_STAGE, __createBubble, false, 0, true);
        	_data = $data;
        	_isPrimary = $isPrimary;
        	__init();
    	}
		////////////////////////////////////////////////////////////
		//
		// Public Methods
		//
		////////////////////////////////////////////////////////////
		
		/**
		 * Cleans up for garbage collection
		 *
		 */
		public function dispose():void
		{
			//if dispose fails ... let it fail silently
			try 
			{
				MemoryCleaner.dispose(this);
				_linkCopyContainer.removeEventListener(MouseEvent.ROLL_OVER, __handleRollOver);
				_linkCopyContainer.removeEventListener(MouseEvent.ROLL_OUT, __handleRollOut);
				
				_linkCopyContainer = null;
				_bubble = null;
				_linkCopy = null;
				
			}
			catch($evt:Error){ throw new Error('Error disposing' + this);}
		}
		
		////////////////////////////////////////////////////////////
		// Event Handlers
		////////////////////////////////////////////////////////////
		private function __handleRollOver($e:MouseEvent):void
		{
			TweenLite.to(_bubble, .35, {autoAlpha:1});
		}
		
		private function __handleRollOut($e:MouseEvent):void
		{
			TweenLite.to(_bubble, .35, {autoAlpha:0});
		}

		////////////////////////////////////////////////////////////
		// Getters / Setters
		////////////////////////////////////////////////////////////
		public function get visibleHeight():Number
		{
			return  _linkCopy.textHeight;
		}
		////////////////////////////////////////////////////////////
		//
		// Private Methods
		//
		////////////////////////////////////////////////////////////
		
		private function __init():void
		{
			_colorClass = (_isPrimary) ? 'primaryProviderColor' : 'providerColor';
			_linkCopyContainer = new Sprite();
			_linkCopyContainer.buttonMode = true;
			addChild(_linkCopyContainer);
			_linkCopy = TextFieldUtils.createTextField(0,0,100,20,TextFieldAutoSize.LEFT,false);
			_linkCopy.mouseEnabled = false;
			_linkCopy.antiAliasType = AntiAliasType.ADVANCED;
			_linkCopy.htmlText = '<span class="details">'+'<span class ="'+_colorClass+'">'+MetaManager.getInstance().getLabel('details')+'</span>'+'</span>';
			_linkCopyContainer.addChild(_linkCopy);
			
			_linkCopyContainer.addEventListener(MouseEvent.ROLL_OVER, __handleRollOver,false, 0, true);
			_linkCopyContainer.addEventListener(MouseEvent.ROLL_OUT, __handleRollOut,false, 0, true);
		}

		private function __createBubble($e:Event):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, __createBubble);
			_bubble = new DetailsBubble(_data.title, _data.description);
			_bubble.x = (this.x - (_bubble.width>>1) > 20) ? ((_linkCopy.textWidth - _bubble.width) >> 1) + 5 : -this.x + 20;
			_bubble.setArrowX(Math.abs(_bubble.x)+(_linkCopy.textWidth>>1)-4);
			_bubble.y = -_bubble.height;
			addChild(_bubble);
			
			_bubble.visible = false;
			_bubble.alpha = 0;
		}
    }
}